package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.ValidationHelper;
import gov.va.vinci.dart.common.exception.ValidationException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="narrative", schema="hib")
public class Narrative extends BusinessObject {

	@JoinColumn(name = "requestid")
	@ManyToOne(fetch = FetchType.LAZY)
	private Request request;
	
	@Column(name="text", columnDefinition = "varchar(max)")
	private String text;
	
	Narrative(){}
	
	public static Narrative create(final String description, final Request request, final String userId, final String text) throws ValidationException {
		ValidationHelper.required("Description", description);
		ValidationHelper.required("Request", request);
		ValidationHelper.required("User Id", userId);
		ValidationHelper.required("Text", text);
		
		Narrative comment = new Narrative();
		comment.createdBy = userId;
		comment.createdOn = new Date();
		comment.request = request;
		comment.description = description;
		comment.name = "comment";
		comment.text = text;

		DartObjectFactory.getInstance().getNarrativeDAO().save(comment);
		return comment;
	}
	
	public static Narrative findById(final int commentId) {
		return DartObjectFactory.getInstance().getNarrativeDAO().findById(commentId);
	}
	
	public String getText() {
		return text;
	}
	
	public void setText(String text) {
		this.text = text;
	}
	
	public Request getRequest() {
		return request;
	}
	
	public void updateText(final String userId, final String newText) throws ValidationException {
		ValidationHelper.required("User Id", userId);
		ValidationHelper.required("Narrative Text", newText);
		
		text = newText;
		updatedBy = userId;
		updatedOn = new Date();
	}
}
